local WEAPONS = json.decode(LoadResourceFile(GetCurrentResourceName(), 'hashes.json'))

--#region Logs
Citizen.CreateThread(function()
    local lastPedAimed = nil

    while true do
        Wait(250)

        local playerPed = PlayerPedId()

        -- return if ped doesnt exist or not armed
        if DoesEntityExist(playerPed) and IsPedArmed(playerPed, 4) then
            local isAiming, targetPed = GetEntityPlayerIsFreeAimingAt(PlayerId(-1))

            -- is currently aiming
            if isAiming then
                -- is a new target
                if targetPed ~= lastPedAimed then
                    lastPedAimed = targetPed
                    -- target is a player
                    if DoesEntityExist(targetPed) and IsEntityAPed(targetPed) and IsPedAPlayer(targetPed) then
                        local targetId = NetworkGetPlayerIndexFromPed(targetPed)

                        -- has net id
                        if targetId then
                            local targetSvId = GetPlayerServerId(targetId)

                            -- if server id not nil
                            if targetSvId then
                                local weapon = GetSelectedPedWeapon(playerPed)
                                TriggerServerEvent('unlimited::spectre::aimedAtPlayer', targetSvId, WEAPONS[tostring(weapon)])
                            end
                        end
                    end
                end

                -- wait longer due aiming same player
                Wait(1500)
            else
                -- reset if ped stopped aiming
                lastPedAimed = nil
            end
        end
    end
end)
--#endregion Logs

--#region Player
local function findZForCoords(x, y)
    local found = true
    local START_Z = 1500
    local z = START_Z

    while found and z > 0 do
        local _found, _z = GetGroundZFor_3dCoord(x + 0.0, y + 0.0, z - 1.0)
        if _found then
            z = _z + 0.0
        end
        found = _found
        Wait(0)
    end

    if z == START_Z then
        return nil
    end

    return z + 0.0
end

RegisterNetEvent('unlWeb:player:teleport', function(coords)
    local x = (16 ^ 13) + tonumber(coords.x) - (16 ^ 13)
    local y = (16 ^ 13) + tonumber(coords.y) - (16 ^ 13)
    local z = (16 ^ 13) + tonumber(coords.z) - (16 ^ 13)
    local ped = PlayerPedId()
    local veh = GetVehiclePedIsIn(ped, false)

    SetPedCoordsKeepVehicle(ped, x, y, 100.0)

    if veh > 0 then
        FreezeEntityPosition(veh, true)
    else
        FreezeEntityPosition(ped, true)
    end

    while IsEntityWaitingForWorldCollision(ped) do
        Wait(100)
    end

    local _finalZ
    local DELAY = 500
    for i = 1, 5 do
        if _finalZ ~= nil then break end
        _finalZ = findZForCoords(x, y)
        if _z == nil then
            Wait(DELAY)
        end
    end
    if _finalZ ~= nil then
        z = _finalZ
    end

    ped = PlayerPedId()
    SetPedCoordsKeepVehicle(ped, x, y, z)
    if veh > 0 then
        FreezeEntityPosition(veh, false)
    else
        FreezeEntityPosition(ped, false)
    end

    SetGameplayCamRelativeHeading(0)
end)

RegisterNetEvent('unlWeb:player:heal', function()
    local player = PlayerPedId()

    SetEntityMaxHealth(player, 200)
    SetEntityHealth(player, 200)
    ClearPedBloodDamage(player)
end)
--#endregion Player

--#region Vehicle
local function getVehicleHandle(plate)
    local vehiclePool = GetGamePool('CVehicle')
    local foundHandle = false

    for i = 1, #vehiclePool do
        local handle = vehiclePool[i]
        local curPlate = GetVehicleNumberPlateText(handle)

        if curPlate == plate then
            foundHandle = handle
            break
        end
    end

    return foundHandle
end

RegisterNetEvent('unlWeb:vehicle:fuel', function(plate, value)
    local veh = getVehicleHandle(plate)
    local fuel =  (16 ^ 13) + value - (16 ^ 13)

    if not veh then
        return
    end

    if fuel > 100 then
        fuel = 100
    end

    SetVehicleFuelLevel(veh, (16 ^ 13) + fuel - (16 ^ 13))
    DecorSetFloat(veh, '_FUEL_LEVEL', GetVehicleFuelLevel(veh))
end)

RegisterNetEvent('unlWeb:vehicle:body', function(plate, value)
    local veh = getVehicleHandle(plate)

    if not veh then
        return
    end

    SetVehicleBodyHealth(veh, (16 ^ 13) + value - (16 ^ 13))
end)

RegisterNetEvent('unlWeb:vehicle:engine', function(plate, value)
    local veh = getVehicleHandle(plate)

    if not veh then
        return
    end

    SetVehicleEngineHealth(veh, (16 ^ 13) + value - (16 ^ 13))
end)

RegisterNetEvent('unlWeb:vehicle:repair', function(plate)
    local veh = getVehicleHandle(plate)

    if not veh then
        return
    end

    SetVehicleFuelLevel(veh, 100.0)
    DecorSetFloat(veh, '_FUEL_LEVEL', GetVehicleFuelLevel(veh))
    SetVehicleUndriveable(veh, false)
    SetVehicleFixed(veh)
    SetVehicleEngineOn(veh, true, false, true)
    SetVehicleDirtLevel(veh, 0.0)
    SetVehicleOnGroundProperly(veh)
end)
--#endregion Vehicle


print('This Server is running Unlimited - Spectre by Unlimited.wtf')

