import { ACTION, RESOURCE } from '../../../../common/permissions'

export default [
  {
    title: 'dashboard',
    icon: 'fas fa-tachometer-alt',
    route: 'dashboard',
    resource: RESOURCE.APP,
    action: ACTION.APP.DASHBOARD,
  },
  {
    header: 'gameserver',
    children: [
      { resource: RESOURCE.GAME, action: ACTION.GAME.LIVEMAP.READ },
      { resource: RESOURCE.GAME, action: ACTION.GAME.PLAYER.READ },
      { resource: RESOURCE.GAME, action: ACTION.GAME.VEHICLE.READ },
      { resource: RESOURCE.GAME, action: ACTION.GAME.STASHES.READ },
      { resource: RESOURCE.GAME, action: ACTION.GAME.LOGS.READ },
    ],
  },
  {
    title: 'livemap',
    icon: 'fas fa-map',
    route: 'game-live-map',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.LIVEMAP.READ,
  },
  {
    title: 'waypoint',
    icon: 'push_pin',
    route: 'game-waypoint-list',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.WAYPOINT.READ,
  },
  {
    title: 'account',
    icon: 'account_tree',
    route: 'game-account-list',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.ACCOUNT.READ,
  },
  {
    title: 'player',
    icon: 'fas fa-user',
    route: 'game-player-list',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.PLAYER.READ,
  },
  {
    title: 'vehicle',
    icon: 'fas fa-car',
    route: 'game-vehicle-list',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.VEHICLE.READ,
  },
  {
    title: 'stashes',
    icon: 'fas fa-box-open',
    route: 'game-stashes-list',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.STASHES.READ,
  },
  {
    title: 'logs',
    icon: 'description',
    route: 'game-logs',
    resource: RESOURCE.GAME,
    action: ACTION.GAME.LOGS.READ,
  },
  {
    header: 'development',
    children: [
      { resource: RESOURCE.DEV, action: ACTION.DEV.VEHICLE.READ },
      { resource: RESOURCE.DEV, action: ACTION.DEV.ITEM.READ },
      { resource: RESOURCE.DEV, action: ACTION.DEV.JOB.READ },
      { resource: RESOURCE.DEV, action: ACTION.DEV.GANG.READ },
    ],
  },
  {
    title: 'items',
    icon: 'fas fa-archive',
    route: 'dev-item-list',
    resource: RESOURCE.DEV,
    action: ACTION.DEV.ITEM.READ,
  },
  {
    title: 'jobs',
    icon: 'fas fa-briefcase',
    route: 'dev-job-list',
    resource: RESOURCE.DEV,
    action: ACTION.DEV.JOB.READ,
  },
  {
    title: 'gangs',
    icon: 'fas fa-user-ninja',
    route: 'dev-gang-list',
    resource: RESOURCE.DEV,
    action: ACTION.DEV.GANG.READ,
  },
  {
    title: 'vehicle',
    icon: 'fas fa-car',
    route: 'dev-vehicle-list',
    resource: RESOURCE.DEV,
    action: ACTION.DEV.VEHICLE.READ,
  },
  {
    header: 'management',
    children: [
      {
        resource: RESOURCE.WEB,
        action: ACTION.WEB.USER.READ,
      },
      {
        resource: RESOURCE.WEB,
        action: ACTION.WEB.ROLE.READ,
      },
      {
        resource: RESOURCE.WEB,
        action: ACTION.WEB.CONFIG.READ,
      },
    ],
  },
  {
    title: 'users',
    icon: 'fas fa-user',
    route: 'web-user-list',
    resource: RESOURCE.WEB,
    action: ACTION.WEB.USER.READ,
  },
  {
    title: 'roles',
    icon: 'fas fa-users',
    route: 'web-role-list',
    resource: RESOURCE.WEB,
    action: ACTION.WEB.ROLE.READ,
  },
  {
    title: 'config',
    icon: 'settings_suggest',
    route: 'web-config',
    resource: RESOURCE.WEB,
    action: ACTION.WEB.CONFIG.READ,
  },
]
