QBCore = nil

local QBName = nil

local vehDefault = {
    name = '',
    brand = '',
    model = '',
    price = nil,
    category = '',
    categoryLabel = '',
    hash = '',
    shop = '',
}

-- Load shared files
local function loadSharedFile(res, file, content)
    local caller = GetInvokingResource()

    if (caller ~= GetCurrentResourceName()) then
        print(string.format('Loading Shared File was called by resource %s and got denied.', caller))
        return nil
    end

    local fileData = LoadResourceFile(res, "/shared/" .. file .. ".lua")
    local data = load(fileData .. " return " .. content)()

    return data
end

exports('loadSharedFile', loadSharedFile)

-- Ban Helper
local function getOsTime()
    return os.time()
end

exports('getOsTime', getOsTime)

-- Inventory parse
local function parseItemUpdate(res, citizenid, items)
    local caller = GetInvokingResource()

    if (caller ~= GetCurrentResourceName()) then
        print(string.format('ParseItemUpdate was called by resource %s and got denied.', caller))
        return nil
    end

    local parsedItems = {}
    for k, v in pairs(items) do
        local isNumber = tonumber(v.slot)

        if isNumber == nil then
            v.slot = k
            parsedItems[k] = v
        else
            v.slot = tonumber(v.slot)
            parsedItems[tonumber(k)] = v
        end
    end

    local player = QBCore.Functions.GetPlayerByCitizenId(citizenid)
    if not player then
        player = QBCore.Functions.GetOfflinePlayerByCitizenId(citizenid)
    end
    if player then
        player.Functions.SetPlayerData('items', parsedItems)
        if player.Offline then
            player.Functions.Save()
        end
    end
end

exports('parseItemUpdate', parseItemUpdate)

--#region Vehicle
local function AddVehicle(vehName, veh, obj)
    if type(vehName) ~= "string" then
        return false, "invalid_veh_name"
    end

    if QBCore.Shared.Vehicles[vehName] then
        return false, "veh_exists"
    end

    veh['hash'] = joaat(veh['model'])

    QBCore = exports[QBName]:GetCoreObject()
    QBCore.Shared.Vehicles[vehName] = veh
    QBCore.Shared.UnlCache.Vehicles[vehName] = veh

    TriggerClientEvent(obj .. ':Client:OnSharedUpdate', -1, 'Vehicles', vehName, veh)
    local resCode, resMsg = QBCore.Functions.SetField('Shared', QBCore.Shared)

    return resCode, resMsg
end

local function UpdateVehicle(vehName, veh, obj)
    if type(vehName) ~= "string" then
        return false, "invalid_veh_name"
    end

    if not QBCore.Shared.Vehicles[vehName] then
        return false, "veh_not_exists"
    end

    veh['hash'] = joaat(veh['model'])

    QBCore = exports[QBName]:GetCoreObject()
    QBCore.Shared.Vehicles[vehName] = veh
    QBCore.Shared.UnlCache.Vehicles[vehName] = veh

    TriggerClientEvent(obj .. ':Client:OnSharedUpdate', -1, 'Vehicles', vehName, veh)
    local resCode, resMsg = QBCore.Functions.SetField('Shared', QBCore.Shared)

    return resCode, resMsg
end

local function RemoveVehicle(vehName, obj)
    if type(vehName) ~= "string" then
        return false, "invalid_veh_name"
    end

    if not QBCore.Shared.Vehicles[vehName] then
        return false, "veh_not_exists"
    end

    QBCore = exports[QBName]:GetCoreObject()
    QBCore.Shared.Vehicles[vehName] = nil
    QBCore.Shared.UnlCache.Vehicles[vehName] = vehDefault

    TriggerClientEvent(obj .. ':Client:OnSharedUpdate', -1, 'Vehicles', vehName, nil)
    local resCode, resMsg = QBCore.Functions.SetField('Shared', QBCore.Shared)

    return resCode, resMsg
end
--#endregion Vehicle

--#region LoadUp
local function initLua(res, obj)
    local caller = GetInvokingResource()
    if (caller ~= GetCurrentResourceName()) then
        print(string.format('Init Lua was called by resource %s and got denied.', caller))
        return false, "denied"
    end

    QBCore = exports[res]:GetCoreObject()
    QBName = res

    if not QBCore.Shared.UnlCache then
        -- init cache
        QBCore.Shared.UnlCache = {
            Vehicles = {}
        }
        QBCore.Functions.SetField('Shared', QBCore.Shared)
    else
        -- send already existing cache to players
        for key, value in pairs(QBCore.Shared.UnlCache) do
          for _, playerId in ipairs(GetPlayers()) do
              TriggerClientEvent(obj .. ':Client:OnSharedUpdateMultiple', playerId, key, value)
          end
        end
    end

    -- update local QBCore on change
    AddEventHandler(obj .. ':Server:UpdateObject', function()
        QBCore = exports[res]:GetCoreObject()
    end)

    -- send cached changes to new connected player
    AddEventHandler(obj .. ':Server:PlayerLoaded', function(player)
        local src = player.PlayerData.source
        if not QBCore.Shared.UnlCache then return end

        for key, value in pairs(QBCore.Shared.UnlCache) do
            TriggerClientEvent(obj .. ':Client:OnSharedUpdateMultiple', src, key, value)
        end
    end)

    -- register shared vehicle methods
    local resCode, resMsg = QBCore.Functions.SetMethod('AddVehicle', function(vehName, veh)
        return AddVehicle(vehName, veh, obj)
    end)

    local resCode, resMsg = QBCore.Functions.SetMethod('UpdateVehicle', function(vehName, veh)
        return UpdateVehicle(vehName, veh, obj)
    end)

    local resCode, resMsg = QBCore.Functions.SetMethod('RemoveVehicle', function(vehName)
        return RemoveVehicle(vehName, obj)
    end)

    return resCode, resMsg
end

exports('initLua', initLua)
--#endregion LoadUp

--#region getHWID
local function getHWID(ServerId)
    local playerTokens = {}

    local numtokens = GetNumPlayerTokens(ServerId)
    for i = 1, numtokens do
        local token = GetPlayerToken(ServerId, i)
        table.insert(playerTokens, token)
    end

    return json.encode(playerTokens)
end

exports('getHWID', getHWID)
--#endregion getHWID
